/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#pragma once

#include <rtl/ustring.hxx>

inline constexpr OUStringLiteral HID_INSWIN_POS = u"SC_HID_INSWIN_POS";
inline constexpr OUStringLiteral HID_INSWIN_CALC = u"SC_HID_INSWIN_CALC";
inline constexpr OUStringLiteral HID_INSWIN_CANCEL = u"SC_HID_INSWIN_CANCEL";
inline constexpr OUStringLiteral HID_INSWIN_OK = u"SC_HID_INSWIN_OK";
inline constexpr OUStringLiteral HID_INSWIN_SUMME = u"SC_HID_INSWIN_SUMME";
inline constexpr OUStringLiteral HID_INSWIN_FUNC = u"SC_HID_INSWIN_FUNC";
inline constexpr OUStringLiteral HID_INSWIN_INPUT = u"SC_HID_INSWIN_INPUT";

// Help IDs for document window ----------------------------------------------
inline constexpr OUStringLiteral HID_SC_WIN_GRIDWIN = u"SC_HID_SC_WIN_GRIDWIN";
inline constexpr OUStringLiteral HID_SC_WIN_PREVIEW = u"SC_HID_SC_WIN_PREVIEW";

inline constexpr OUStringLiteral HID_SC_HEADER_EDIT = u"SC_HID_SC_HEADER_EDIT";
inline constexpr OUStringLiteral HID_SC_FOOTER_EDIT = u"SC_HID_SC_FOOTER_EDIT";

inline constexpr OUStringLiteral HID_SC_SCENWIN_TOP = u"SC_HID_SC_SCENWIN_TOP";
inline constexpr OUStringLiteral HID_SC_SCENWIN_BOTTOM = u"SC_HID_SC_SCENWIN_BOTTOM";

inline constexpr OUStringLiteral HID_SC_INPUTWIN = u"SC_HID_SC_INPUTWIN";

inline constexpr OUStringLiteral HID_SC_RENAME_NAME = u"SC_HID_SC_RENAME_NAME";
inline constexpr OUStringLiteral HID_SC_APPEND_NAME = u"SC_HID_SC_APPEND_NAME";

inline constexpr OUStringLiteral HID_SC_ADD_AUTOFMT = u"SC_HID_SC_ADD_AUTOFMT";
inline constexpr OUStringLiteral HID_SC_AUTOFMT_NAME = u"SC_HID_SC_AUTOFMT_NAME";

//  wrong group - HID_SC_DLG_START is full
inline constexpr OUStringLiteral HID_SC_REN_AFMT_NAME = u"SC_HID_SC_REN_AFMT_NAME";

inline constexpr OUStringLiteral HID_CHG_PROTECT = u"SC_HID_CHG_PROTECT";


inline constexpr OUStringLiteral HID_SC_REN_AFMT_DLG = u"SC_HID_SC_REN_AFMT_DLG";

// Help IDs for Submenus (max.50) --------------------------------------------
inline constexpr OUStringLiteral HID_PASSWD_TABLE = u"SC_HID_PASSWD_TABLE";
inline constexpr OUStringLiteral HID_PASSWD_DOC = u"SC_HID_PASSWD_DOC";
inline constexpr OUStringLiteral HID_PASSWD_DOC_CONFIRM = u"SC_HID_PASSWD_DOC_CONFIRM";


// Other help IDs (max.70) ---------------------------------------------------
inline constexpr OUStringLiteral HID_SELECTTABLES = u"SC_HID_SELECTTABLES";
inline constexpr OUStringLiteral HID_GOTOTABLE  = u"SC_HID_GOTOTABLE";
inline constexpr OUStringLiteral HID_GOTOTABLEMASK  = u"SC_HID_GOTOTABLEMASK";


// Analysis Addin Functions (max.120) ----------------------------------------
inline constexpr OUStringLiteral HID_AAI_FUNC_WORKDAY = u"SC_HID_AAI_FUNC_WORKDAY";
inline constexpr OUStringLiteral HID_AAI_FUNC_YEARFRAC = u"SC_HID_AAI_FUNC_YEARFRAC";
inline constexpr OUStringLiteral HID_AAI_FUNC_EDATE = u"SC_HID_AAI_FUNC_EDATE";
inline constexpr OUStringLiteral HID_AAI_FUNC_WEEKNUM = u"SC_HID_AAI_FUNC_WEEKNUM";
inline constexpr OUStringLiteral HID_AAI_FUNC_EOMONTH = u"SC_HID_AAI_FUNC_EOMONTH";
inline constexpr OUStringLiteral HID_AAI_FUNC_NETWORKDAYS = u"SC_HID_AAI_FUNC_NETWORKDAYS";
inline constexpr OUStringLiteral HID_AAI_FUNC_AMORDEGRC = u"SC_HID_AAI_FUNC_AMORDEGRC";
inline constexpr OUStringLiteral HID_AAI_FUNC_AMORLINC = u"SC_HID_AAI_FUNC_AMORLINC";
inline constexpr OUStringLiteral HID_AAI_FUNC_ACCRINT = u"SC_HID_AAI_FUNC_ACCRINT";
inline constexpr OUStringLiteral HID_AAI_FUNC_ACCRINTM = u"SC_HID_AAI_FUNC_ACCRINTM";
inline constexpr OUStringLiteral HID_AAI_FUNC_RECEIVED = u"SC_HID_AAI_FUNC_RECEIVED";
inline constexpr OUStringLiteral HID_AAI_FUNC_DISC = u"SC_HID_AAI_FUNC_DISC";
inline constexpr OUStringLiteral HID_AAI_FUNC_DURATION = u"SC_HID_AAI_FUNC_DURATION";
inline constexpr OUStringLiteral HID_AAI_FUNC_EFFECT = u"SC_HID_AAI_FUNC_EFFECT";
inline constexpr OUStringLiteral HID_AAI_FUNC_CUMPRINC = u"SC_HID_AAI_FUNC_CUMPRINC";
inline constexpr OUStringLiteral HID_AAI_FUNC_CUMIPMT = u"SC_HID_AAI_FUNC_CUMIPMT";
inline constexpr OUStringLiteral HID_AAI_FUNC_PRICE = u"SC_HID_AAI_FUNC_PRICE";
inline constexpr OUStringLiteral HID_AAI_FUNC_PRICEDISC = u"SC_HID_AAI_FUNC_PRICEDISC";
inline constexpr OUStringLiteral HID_AAI_FUNC_PRICEMAT = u"SC_HID_AAI_FUNC_PRICEMAT";
inline constexpr OUStringLiteral HID_AAI_FUNC_MDURATION = u"SC_HID_AAI_FUNC_MDURATION";
inline constexpr OUStringLiteral HID_AAI_FUNC_NOMINAL = u"SC_HID_AAI_FUNC_NOMINAL";
inline constexpr OUStringLiteral HID_AAI_FUNC_DOLLARFR = u"SC_HID_AAI_FUNC_DOLLARFR";
inline constexpr OUStringLiteral HID_AAI_FUNC_DOLLARDE = u"SC_HID_AAI_FUNC_DOLLARDE";
inline constexpr OUStringLiteral HID_AAI_FUNC_YIELD = u"SC_HID_AAI_FUNC_YIELD";
inline constexpr OUStringLiteral HID_AAI_FUNC_YIELDDISC = u"SC_HID_AAI_FUNC_YIELDDISC";
inline constexpr OUStringLiteral HID_AAI_FUNC_YIELDMAT = u"SC_HID_AAI_FUNC_YIELDMAT";
inline constexpr OUStringLiteral HID_AAI_FUNC_TBILLEQ = u"SC_HID_AAI_FUNC_TBILLEQ";
inline constexpr OUStringLiteral HID_AAI_FUNC_TBILLPRICE = u"SC_HID_AAI_FUNC_TBILLPRICE";
inline constexpr OUStringLiteral HID_AAI_FUNC_TBILLYIELD = u"SC_HID_AAI_FUNC_TBILLYIELD";
inline constexpr OUStringLiteral HID_AAI_FUNC_ODDFPRICE = u"SC_HID_AAI_FUNC_ODDFPRICE";
inline constexpr OUStringLiteral HID_AAI_FUNC_ODDFYIELD = u"SC_HID_AAI_FUNC_ODDFYIELD";
inline constexpr OUStringLiteral HID_AAI_FUNC_ODDLPRICE = u"SC_HID_AAI_FUNC_ODDLPRICE";
inline constexpr OUStringLiteral HID_AAI_FUNC_ODDLYIELD = u"SC_HID_AAI_FUNC_ODDLYIELD";
inline constexpr OUStringLiteral HID_AAI_FUNC_XIRR = u"SC_HID_AAI_FUNC_XIRR";
inline constexpr OUStringLiteral HID_AAI_FUNC_XNPV = u"SC_HID_AAI_FUNC_XNPV";
inline constexpr OUStringLiteral HID_AAI_FUNC_INTRATE = u"SC_HID_AAI_FUNC_INTRATE";
inline constexpr OUStringLiteral HID_AAI_FUNC_COUPNCD = u"SC_HID_AAI_FUNC_COUPNCD";
inline constexpr OUStringLiteral HID_AAI_FUNC_COUPDAYS = u"SC_HID_AAI_FUNC_COUPDAYS";
inline constexpr OUStringLiteral HID_AAI_FUNC_COUPDAYSNC = u"SC_HID_AAI_FUNC_COUPDAYSNC";
inline constexpr OUStringLiteral HID_AAI_FUNC_COUPDAYBS = u"SC_HID_AAI_FUNC_COUPDAYBS";
inline constexpr OUStringLiteral HID_AAI_FUNC_COUPPCD = u"SC_HID_AAI_FUNC_COUPPCD";
inline constexpr OUStringLiteral HID_AAI_FUNC_COUPNUM = u"SC_HID_AAI_FUNC_COUPNUM";
inline constexpr OUStringLiteral HID_AAI_FUNC_FVSCHEDULE = u"SC_HID_AAI_FUNC_FVSCHEDULE";
inline constexpr OUStringLiteral HID_AAI_FUNC_ISEVEN = u"SC_HID_AAI_FUNC_ISEVEN";
inline constexpr OUStringLiteral HID_AAI_FUNC_ISODD = u"SC_HID_AAI_FUNC_ISODD";
inline constexpr OUStringLiteral HID_AAI_FUNC_GCD = u"SC_HID_AAI_FUNC_GCD";
inline constexpr OUStringLiteral HID_AAI_FUNC_LCM = u"SC_HID_AAI_FUNC_LCM";
inline constexpr OUStringLiteral HID_AAI_FUNC_MULTINOMIAL = u"SC_HID_AAI_FUNC_MULTINOMIAL";
inline constexpr OUStringLiteral HID_AAI_FUNC_SERIESSUM = u"SC_HID_AAI_FUNC_SERIESSUM";
inline constexpr OUStringLiteral HID_AAI_FUNC_QUOTIENT = u"SC_HID_AAI_FUNC_QUOTIENT";
inline constexpr OUStringLiteral HID_AAI_FUNC_MROUND = u"SC_HID_AAI_FUNC_MROUND";
inline constexpr OUStringLiteral HID_AAI_FUNC_SQRTPI = u"SC_HID_AAI_FUNC_SQRTPI";
inline constexpr OUStringLiteral HID_AAI_FUNC_RANDBETWEEN = u"SC_HID_AAI_FUNC_RANDBETWEEN";
inline constexpr OUStringLiteral HID_AAI_FUNC_BESSELI = u"SC_HID_AAI_FUNC_BESSELI";
inline constexpr OUStringLiteral HID_AAI_FUNC_BESSELJ = u"SC_HID_AAI_FUNC_BESSELJ";
inline constexpr OUStringLiteral HID_AAI_FUNC_BESSELK = u"SC_HID_AAI_FUNC_BESSELK";
inline constexpr OUStringLiteral HID_AAI_FUNC_BESSELY = u"SC_HID_AAI_FUNC_BESSELY";
inline constexpr OUStringLiteral HID_AAI_FUNC_BIN2DEC = u"SC_HID_AAI_FUNC_BIN2DEC";
inline constexpr OUStringLiteral HID_AAI_FUNC_BIN2HEX = u"SC_HID_AAI_FUNC_BIN2HEX";
inline constexpr OUStringLiteral HID_AAI_FUNC_BIN2OCT = u"SC_HID_AAI_FUNC_BIN2OCT";
inline constexpr OUStringLiteral HID_AAI_FUNC_DELTA = u"SC_HID_AAI_FUNC_DELTA";
inline constexpr OUStringLiteral HID_AAI_FUNC_DEC2BIN = u"SC_HID_AAI_FUNC_DEC2BIN";
inline constexpr OUStringLiteral HID_AAI_FUNC_DEC2HEX = u"SC_HID_AAI_FUNC_DEC2HEX";
inline constexpr OUStringLiteral HID_AAI_FUNC_DEC2OCT = u"SC_HID_AAI_FUNC_DEC2OCT";
inline constexpr OUStringLiteral HID_AAI_FUNC_ERF = u"SC_HID_AAI_FUNC_ERF";
inline constexpr OUStringLiteral HID_AAI_FUNC_ERFC = u"SC_HID_AAI_FUNC_ERFC";
inline constexpr OUStringLiteral HID_AAI_FUNC_GESTEP = u"SC_HID_AAI_FUNC_GESTEP";
inline constexpr OUStringLiteral HID_AAI_FUNC_HEX2BIN = u"SC_HID_AAI_FUNC_HEX2BIN";
inline constexpr OUStringLiteral HID_AAI_FUNC_HEX2DEC = u"SC_HID_AAI_FUNC_HEX2DEC";
inline constexpr OUStringLiteral HID_AAI_FUNC_HEX2OCT = u"SC_HID_AAI_FUNC_HEX2OCT";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMABS = u"SC_HID_AAI_FUNC_IMABS";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMAGINARY = u"SC_HID_AAI_FUNC_IMAGINARY";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMPOWER = u"SC_HID_AAI_FUNC_IMPOWER";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMARGUMENT = u"SC_HID_AAI_FUNC_IMARGUMENT";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMCOS = u"SC_HID_AAI_FUNC_IMCOS";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMDIV = u"SC_HID_AAI_FUNC_IMDIV";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMEXP = u"SC_HID_AAI_FUNC_IMEXP";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMCONJUGATE = u"SC_HID_AAI_FUNC_IMCONJUGATE";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMLN = u"SC_HID_AAI_FUNC_IMLN";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMLOG10 = u"SC_HID_AAI_FUNC_IMLOG10";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMLOG2 = u"SC_HID_AAI_FUNC_IMLOG2";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMPRODUCT = u"SC_HID_AAI_FUNC_IMPRODUCT";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMREAL = u"SC_HID_AAI_FUNC_IMREAL";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMSIN = u"SC_HID_AAI_FUNC_IMSIN";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMSUB = u"SC_HID_AAI_FUNC_IMSUB";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMSUM = u"SC_HID_AAI_FUNC_IMSUM";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMSQRT = u"SC_HID_AAI_FUNC_IMSQRT";
inline constexpr OUStringLiteral HID_AAI_FUNC_COMPLEX = u"SC_HID_AAI_FUNC_COMPLEX";
inline constexpr OUStringLiteral HID_AAI_FUNC_OCT2BIN = u"SC_HID_AAI_FUNC_OCT2BIN";
inline constexpr OUStringLiteral HID_AAI_FUNC_OCT2DEZ = u"SC_HID_AAI_FUNC_OCT2DEZ";
inline constexpr OUStringLiteral HID_AAI_FUNC_OCT2HEX = u"SC_HID_AAI_FUNC_OCT2HEX";
inline constexpr OUStringLiteral HID_AAI_FUNC_CONVERT = u"SC_HID_AAI_FUNC_CONVERT";
inline constexpr OUStringLiteral HID_AAI_FUNC_FACTDOUBLE = u"SC_HID_AAI_FUNC_FACTDOUBLE";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMTAN = u"SC_HID_AAI_FUNC_IMTAN";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMSEC = u"SC_HID_AAI_FUNC_IMSEC";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMCSC = u"SC_HID_AAI_FUNC_IMCSC";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMCOT = u"SC_HID_AAI_FUNC_IMCOT";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMSINH = u"SC_HID_AAI_FUNC_IMSINH";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMCOSH = u"SC_HID_AAI_FUNC_IMCOSH";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMSECH = u"SC_HID_AAI_FUNC_IMSECH";
inline constexpr OUStringLiteral HID_AAI_FUNC_IMCSCH = u"SC_HID_AAI_FUNC_IMCSCH";

inline constexpr OUStringLiteral HID_UPDATE_LINK_WARNING = u"cui/ui/baselinksdialog/UPDATE_NOW";

// DateFunc Addin Functions (max.20) -----------------------------------------
inline constexpr OUStringLiteral HID_DAI_FUNC_DAYSINMONTH = u"SC_HID_DAI_FUNC_DAYSINMONTH";
inline constexpr OUStringLiteral HID_DAI_FUNC_DAYSINYEAR = u"SC_HID_DAI_FUNC_DAYSINYEAR";
inline constexpr OUStringLiteral HID_DAI_FUNC_WEEKSINYEAR = u"SC_HID_DAI_FUNC_WEEKSINYEAR";
inline constexpr OUStringLiteral HID_DAI_FUNC_DIFFMONTHS = u"SC_HID_DAI_FUNC_DIFFMONTHS";
inline constexpr OUStringLiteral HID_DAI_FUNC_DIFFWEEKS = u"SC_HID_DAI_FUNC_DIFFWEEKS";
inline constexpr OUStringLiteral HID_DAI_FUNC_DIFFYEARS = u"SC_HID_DAI_FUNC_DIFFYEARS";
inline constexpr OUStringLiteral HID_DAI_FUNC_ROT13 = u"SC_HID_DAI_FUNC_ROT13";

// PricingFunc Addin Functions  -----------------------------------------

inline constexpr OUStringLiteral HID_PAI_FUNC_OPT_BARRIER = u"SC_HID_PAI_FUNC_OPT_BARRIER";
inline constexpr OUStringLiteral HID_PAI_FUNC_OPT_TOUCH = u"SC_HID_PAI_FUNC_OPT_TOUCH";
inline constexpr OUStringLiteral HID_PAI_FUNC_OPT_PROB_HIT = u"SC_HID_PAI_FUNC_OPT_PROB_HIT";
inline constexpr OUStringLiteral HID_PAI_FUNC_OPT_PROB_INMONEY = u"SC_HID_PAI_FUNC_OPT_PROB_INMONEY";

// End help IDs ------------------------------------------------------------

inline constexpr OUStringLiteral HID_FUNC_DBANZAHL = u"SC_HID_FUNC_DBANZAHL";
inline constexpr OUStringLiteral HID_FUNC_DBANZAHL2 = u"SC_HID_FUNC_DBANZAHL2";
inline constexpr OUStringLiteral HID_FUNC_DBMITTELWERT = u"SC_HID_FUNC_DBMITTELWERT";
inline constexpr OUStringLiteral HID_FUNC_DBAUSZUG = u"SC_HID_FUNC_DBAUSZUG";
inline constexpr OUStringLiteral HID_FUNC_DBMAX = u"SC_HID_FUNC_DBMAX";
inline constexpr OUStringLiteral HID_FUNC_DBMIN = u"SC_HID_FUNC_DBMIN";
inline constexpr OUStringLiteral HID_FUNC_DBPRODUKT = u"SC_HID_FUNC_DBPRODUKT";
inline constexpr OUStringLiteral HID_FUNC_DBSTDABW = u"SC_HID_FUNC_DBSTDABW";
inline constexpr OUStringLiteral HID_FUNC_DBSTDABWN = u"SC_HID_FUNC_DBSTDABWN";
inline constexpr OUStringLiteral HID_FUNC_DBSUMME = u"SC_HID_FUNC_DBSUMME";
inline constexpr OUStringLiteral HID_FUNC_DBVARIANZ = u"SC_HID_FUNC_DBVARIANZ";
inline constexpr OUStringLiteral HID_FUNC_DBVARIANZEN = u"SC_HID_FUNC_DBVARIANZEN";

inline constexpr OUStringLiteral HID_FUNC_DATUM = u"SC_HID_FUNC_DATUM";
inline constexpr OUStringLiteral HID_FUNC_DATWERT = u"SC_HID_FUNC_DATWERT";
inline constexpr OUStringLiteral HID_FUNC_TAG = u"SC_HID_FUNC_TAG";
inline constexpr OUStringLiteral HID_FUNC_TAGE360 = u"SC_HID_FUNC_TAGE360";
inline constexpr OUStringLiteral HID_FUNC_STUNDE = u"SC_HID_FUNC_STUNDE";
inline constexpr OUStringLiteral HID_FUNC_MINUTE = u"SC_HID_FUNC_MINUTE";
inline constexpr OUStringLiteral HID_FUNC_MONAT = u"SC_HID_FUNC_MONAT";
inline constexpr OUStringLiteral HID_FUNC_JETZT = u"SC_HID_FUNC_JETZT";
inline constexpr OUStringLiteral HID_FUNC_SEKUNDE = u"SC_HID_FUNC_SEKUNDE";
inline constexpr OUStringLiteral HID_FUNC_ZEIT = u"SC_HID_FUNC_ZEIT";
inline constexpr OUStringLiteral HID_FUNC_ZEITWERT = u"SC_HID_FUNC_ZEITWERT";
inline constexpr OUStringLiteral HID_FUNC_HEUTE = u"SC_HID_FUNC_HEUTE";
inline constexpr OUStringLiteral HID_FUNC_WOCHENTAG = u"SC_HID_FUNC_WOCHENTAG";
inline constexpr OUStringLiteral HID_FUNC_JAHR = u"SC_HID_FUNC_JAHR";
inline constexpr OUStringLiteral HID_FUNC_TAGE = u"SC_HID_FUNC_TAGE";
inline constexpr OUStringLiteral HID_FUNC_DATEDIF = u"SC_HID_FUNC_DATEDIF";
inline constexpr OUStringLiteral HID_FUNC_KALENDERWOCHE = u"SC_HID_FUNC_KALENDERWOCHE";
inline constexpr OUStringLiteral HID_FUNC_OSTERSONNTAG = u"SC_HID_FUNC_OSTERSONNTAG";
inline constexpr OUStringLiteral HID_FUNC_ISOWEEKNUM = u"SC_HID_FUNC_ISOWEEKNUM";

inline constexpr OUStringLiteral HID_FUNC_BW = u"SC_HID_FUNC_BW";
inline constexpr OUStringLiteral HID_FUNC_ZW = u"SC_HID_FUNC_ZW";
inline constexpr OUStringLiteral HID_FUNC_ZZR = u"SC_HID_FUNC_ZZR";
inline constexpr OUStringLiteral HID_FUNC_RMZ = u"SC_HID_FUNC_RMZ";
inline constexpr OUStringLiteral HID_FUNC_ZINS = u"SC_HID_FUNC_ZINS";
inline constexpr OUStringLiteral HID_FUNC_ZINSZ = u"SC_HID_FUNC_ZINSZ";
inline constexpr OUStringLiteral HID_FUNC_KAPZ = u"SC_HID_FUNC_KAPZ";
inline constexpr OUStringLiteral HID_FUNC_KUMKAPITAL = u"SC_HID_FUNC_KUMKAPITAL";
inline constexpr OUStringLiteral HID_FUNC_KUMZINSZ = u"SC_HID_FUNC_KUMZINSZ";
inline constexpr OUStringLiteral HID_FUNC_DIA = u"SC_HID_FUNC_DIA";
inline constexpr OUStringLiteral HID_FUNC_LIA = u"SC_HID_FUNC_LIA";
inline constexpr OUStringLiteral HID_FUNC_GDA = u"SC_HID_FUNC_GDA";
inline constexpr OUStringLiteral HID_FUNC_GDA2 = u"SC_HID_FUNC_GDA2";
inline constexpr OUStringLiteral HID_FUNC_VDB = u"SC_HID_FUNC_VDB";
inline constexpr OUStringLiteral HID_FUNC_EFFEKTIV = u"SC_HID_FUNC_EFFEKTIV";
inline constexpr OUStringLiteral HID_FUNC_NOMINAL = u"SC_HID_FUNC_NOMINAL";
inline constexpr OUStringLiteral HID_FUNC_NBW = u"SC_HID_FUNC_NBW";
inline constexpr OUStringLiteral HID_FUNC_IKV = u"SC_HID_FUNC_IKV";
inline constexpr OUStringLiteral HID_FUNC_LAUFZEIT = u"SC_HID_FUNC_LAUFZEIT";
inline constexpr OUStringLiteral HID_FUNC_ZGZ = u"SC_HID_FUNC_ZGZ";
inline constexpr OUStringLiteral HID_FUNC_QIKV = u"SC_HID_FUNC_QIKV";
inline constexpr OUStringLiteral HID_FUNC_ISPMT = u"SC_HID_FUNC_ISPMT";

inline constexpr OUStringLiteral HID_FUNC_ISTBEZUG = u"SC_HID_FUNC_ISTBEZUG";
inline constexpr OUStringLiteral HID_FUNC_ISTFEHL = u"SC_HID_FUNC_ISTFEHL";
inline constexpr OUStringLiteral HID_FUNC_ISTFEHLER = u"SC_HID_FUNC_ISTFEHLER";
inline constexpr OUStringLiteral HID_FUNC_ISTLEER = u"SC_HID_FUNC_ISTLEER";
inline constexpr OUStringLiteral HID_FUNC_ISTLOG = u"SC_HID_FUNC_ISTLOG";
inline constexpr OUStringLiteral HID_FUNC_ISTNV = u"SC_HID_FUNC_ISTNV";
inline constexpr OUStringLiteral HID_FUNC_ISTKTEXT = u"SC_HID_FUNC_ISTKTEXT";
inline constexpr OUStringLiteral HID_FUNC_ISTTEXT = u"SC_HID_FUNC_ISTTEXT";
inline constexpr OUStringLiteral HID_FUNC_ISTZAHL = u"SC_HID_FUNC_ISTZAHL";
inline constexpr OUStringLiteral HID_FUNC_ISTFORMEL = u"SC_HID_FUNC_ISTFORMEL";
inline constexpr OUStringLiteral HID_FUNC_N = u"SC_HID_FUNC_N";
inline constexpr OUStringLiteral HID_FUNC_NV = u"SC_HID_FUNC_NV";
inline constexpr OUStringLiteral HID_FUNC_TYP = u"SC_HID_FUNC_TYP";
inline constexpr OUStringLiteral HID_FUNC_AKTUELL = u"SC_HID_FUNC_AKTUELL";
inline constexpr OUStringLiteral HID_FUNC_FORMEL = u"SC_HID_FUNC_FORMEL";
inline constexpr OUStringLiteral HID_FUNC_ZELLE = u"SC_HID_FUNC_ZELLE";
inline constexpr OUStringLiteral HID_FUNC_INFO = u"SC_HID_FUNC_INFO";

inline constexpr OUStringLiteral HID_FUNC_FALSCH = u"SC_HID_FUNC_FALSCH";
inline constexpr OUStringLiteral HID_FUNC_NICHT = u"SC_HID_FUNC_NICHT";
inline constexpr OUStringLiteral HID_FUNC_WAHR = u"SC_HID_FUNC_WAHR";
inline constexpr OUStringLiteral HID_FUNC_WENN = u"SC_HID_FUNC_WENN";
inline constexpr OUStringLiteral HID_FUNC_IFERROR = u"SC_HID_FUNC_IFERROR";
inline constexpr OUStringLiteral HID_FUNC_IFNA = u"SC_HID_FUNC_IFNA";
inline constexpr OUStringLiteral HID_FUNC_ODER = u"SC_HID_FUNC_ODER";
inline constexpr OUStringLiteral HID_FUNC_UND = u"SC_HID_FUNC_UND";
inline constexpr OUStringLiteral HID_FUNC_XOR = u"SC_HID_FUNC_XOR";

inline constexpr OUStringLiteral HID_FUNC_ABS = u"SC_HID_FUNC_ABS";
inline constexpr OUStringLiteral HID_FUNC_POTENZ = u"SC_HID_FUNC_POTENZ";
inline constexpr OUStringLiteral HID_FUNC_ANZAHLLEEREZELLEN = u"SC_HID_FUNC_ANZAHLLEEREZELLEN";
inline constexpr OUStringLiteral HID_FUNC_PI = u"SC_HID_FUNC_PI";
inline constexpr OUStringLiteral HID_FUNC_SUMME = u"SC_HID_FUNC_SUMME";
inline constexpr OUStringLiteral HID_FUNC_QUADRATESUMME = u"SC_HID_FUNC_QUADRATESUMME";
inline constexpr OUStringLiteral HID_FUNC_PRODUKT = u"SC_HID_FUNC_PRODUKT";
inline constexpr OUStringLiteral HID_FUNC_SUMMEWENN = u"SC_HID_FUNC_SUMMEWENN";
inline constexpr OUStringLiteral HID_FUNC_AVERAGEIF = u"SC_HID_FUNC_AVERAGEIF";
inline constexpr OUStringLiteral HID_FUNC_SUMIFS = u"SC_HID_FUNC_SUMIFS";
inline constexpr OUStringLiteral HID_FUNC_AVERAGEIFS = u"SC_HID_FUNC_AVERAGEIFS";
inline constexpr OUStringLiteral HID_FUNC_COUNTIFS = u"SC_HID_FUNC_COUNTIFS";
inline constexpr OUStringLiteral HID_FUNC_ZAEHLENWENN = u"SC_HID_FUNC_ZAEHLENWENN";
inline constexpr OUStringLiteral HID_FUNC_WURZEL = u"SC_HID_FUNC_WURZEL";
inline constexpr OUStringLiteral HID_FUNC_ZUFALLSZAHL = u"SC_HID_FUNC_ZUFALLSZAHL";
inline constexpr OUStringLiteral HID_FUNC_ISTGERADE = u"SC_HID_FUNC_ISTGERADE";
inline constexpr OUStringLiteral HID_FUNC_ISTUNGERADE = u"SC_HID_FUNC_ISTUNGERADE";
inline constexpr OUStringLiteral HID_FUNC_KOMBINATIONEN = u"SC_HID_FUNC_KOMBINATIONEN";
inline constexpr OUStringLiteral HID_FUNC_KOMBINATIONEN2 = u"SC_HID_FUNC_KOMBINATIONEN2";
inline constexpr OUStringLiteral HID_FUNC_ARCCOS = u"SC_HID_FUNC_ARCCOS";
inline constexpr OUStringLiteral HID_FUNC_ARCSIN = u"SC_HID_FUNC_ARCSIN";
inline constexpr OUStringLiteral HID_FUNC_ARCOSHYP = u"SC_HID_FUNC_ARCOSHYP";
inline constexpr OUStringLiteral HID_FUNC_ARSINHYP = u"SC_HID_FUNC_ARSINHYP";
inline constexpr OUStringLiteral HID_FUNC_ARCCOT = u"SC_HID_FUNC_ARCCOT";
inline constexpr OUStringLiteral HID_FUNC_ARCTAN = u"SC_HID_FUNC_ARCTAN";
inline constexpr OUStringLiteral HID_FUNC_ARCOTHYP = u"SC_HID_FUNC_ARCOTHYP";
inline constexpr OUStringLiteral HID_FUNC_ARTANHYP = u"SC_HID_FUNC_ARTANHYP";
inline constexpr OUStringLiteral HID_FUNC_COS = u"SC_HID_FUNC_COS";
inline constexpr OUStringLiteral HID_FUNC_SIN = u"SC_HID_FUNC_SIN";
inline constexpr OUStringLiteral HID_FUNC_COT = u"SC_HID_FUNC_COT";
inline constexpr OUStringLiteral HID_FUNC_TAN = u"SC_HID_FUNC_TAN";
inline constexpr OUStringLiteral HID_FUNC_COSHYP = u"SC_HID_FUNC_COSHYP";
inline constexpr OUStringLiteral HID_FUNC_SINHYP = u"SC_HID_FUNC_SINHYP";
inline constexpr OUStringLiteral HID_FUNC_COTHYP = u"SC_HID_FUNC_COTHYP";
inline constexpr OUStringLiteral HID_FUNC_TANHYP = u"SC_HID_FUNC_TANHYP";
inline constexpr OUStringLiteral HID_FUNC_ARCTAN2 = u"SC_HID_FUNC_ARCTAN2";
inline constexpr OUStringLiteral HID_FUNC_COSECANT = u"SC_HID_FUNC_COSECANT";
inline constexpr OUStringLiteral HID_FUNC_SECANT = u"SC_HID_FUNC_SECANT";
inline constexpr OUStringLiteral HID_FUNC_SECANTHYP = u"SC_HID_FUNC_SECANTHYP";
inline constexpr OUStringLiteral HID_FUNC_COSECANTHYP = u"SC_HID_FUNC_COSECANTHYP";
inline constexpr OUStringLiteral HID_FUNC_DEG = u"SC_HID_FUNC_DEG";
inline constexpr OUStringLiteral HID_FUNC_RAD = u"SC_HID_FUNC_RAD";
inline constexpr OUStringLiteral HID_FUNC_EXP = u"SC_HID_FUNC_EXP";
inline constexpr OUStringLiteral HID_FUNC_LOG = u"SC_HID_FUNC_LOG";
inline constexpr OUStringLiteral HID_FUNC_LN = u"SC_HID_FUNC_LN";
inline constexpr OUStringLiteral HID_FUNC_LOG10 = u"SC_HID_FUNC_LOG10";
inline constexpr OUStringLiteral HID_FUNC_FAKULTAET = u"SC_HID_FUNC_FAKULTAET";
inline constexpr OUStringLiteral HID_FUNC_REST = u"SC_HID_FUNC_REST";
inline constexpr OUStringLiteral HID_FUNC_VORZEICHEN = u"SC_HID_FUNC_VORZEICHEN";
inline constexpr OUStringLiteral HID_FUNC_TEILERGEBNIS = u"SC_HID_FUNC_TEILERGEBNIS";
inline constexpr OUStringLiteral HID_FUNC_GANZZAHL = u"SC_HID_FUNC_GANZZAHL";
inline constexpr OUStringLiteral HID_FUNC_KUERZEN = u"SC_HID_FUNC_KUERZEN";
inline constexpr OUStringLiteral HID_FUNC_RUNDEN = u"SC_HID_FUNC_RUNDEN";
inline constexpr OUStringLiteral HID_FUNC_AUFRUNDEN = u"SC_HID_FUNC_AUFRUNDEN";
inline constexpr OUStringLiteral HID_FUNC_ABRUNDEN = u"SC_HID_FUNC_ABRUNDEN";
inline constexpr OUStringLiteral HID_FUNC_GERADE = u"SC_HID_FUNC_GERADE";
inline constexpr OUStringLiteral HID_FUNC_UNGERADE = u"SC_HID_FUNC_UNGERADE";
inline constexpr OUStringLiteral HID_FUNC_OBERGRENZE = u"SC_HID_FUNC_OBERGRENZE";
inline constexpr OUStringLiteral HID_FUNC_UNTERGRENZE = u"SC_HID_FUNC_UNTERGRENZE";
inline constexpr OUStringLiteral HID_FUNC_GGT = u"SC_HID_FUNC_GGT";
inline constexpr OUStringLiteral HID_FUNC_KGV = u"SC_HID_FUNC_KGV";
inline constexpr OUStringLiteral HID_FUNC_UMRECHNEN = u"SC_HID_FUNC_UMRECHNEN";
inline constexpr OUStringLiteral HID_FUNC_EUROCONVERT = u"SC_HID_FUNC_EUROCONVERT";

inline constexpr OUStringLiteral HID_FUNC_MTRANS = u"SC_HID_FUNC_MTRANS";
inline constexpr OUStringLiteral HID_FUNC_MMULT = u"SC_HID_FUNC_MMULT";
inline constexpr OUStringLiteral HID_FUNC_MDET = u"SC_HID_FUNC_MDET";
inline constexpr OUStringLiteral HID_FUNC_MINV = u"SC_HID_FUNC_MINV";
inline constexpr OUStringLiteral HID_FUNC_EINHEITSMATRIX = u"SC_HID_FUNC_EINHEITSMATRIX";
inline constexpr OUStringLiteral HID_FUNC_SUMMENPRODUKT = u"SC_HID_FUNC_SUMMENPRODUKT";
inline constexpr OUStringLiteral HID_FUNC_SUMMEX2MY2 = u"SC_HID_FUNC_SUMMEX2MY2";
inline constexpr OUStringLiteral HID_FUNC_SUMMEX2PY2 = u"SC_HID_FUNC_SUMMEX2PY2";
inline constexpr OUStringLiteral HID_FUNC_SUMMEXMY2 = u"SC_HID_FUNC_SUMMEXMY2";
inline constexpr OUStringLiteral HID_FUNC_HAEUFIGKEIT = u"SC_HID_FUNC_HAEUFIGKEIT";
inline constexpr OUStringLiteral HID_FUNC_RGP = u"SC_HID_FUNC_RGP";
inline constexpr OUStringLiteral HID_FUNC_RKP = u"SC_HID_FUNC_RKP";
inline constexpr OUStringLiteral HID_FUNC_TREND = u"SC_HID_FUNC_TREND";
inline constexpr OUStringLiteral HID_FUNC_VARIATION = u"SC_HID_FUNC_VARIATION";

inline constexpr OUStringLiteral HID_FUNC_ANZAHL = u"SC_HID_FUNC_ANZAHL";
inline constexpr OUStringLiteral HID_FUNC_ANZAHL2 = u"SC_HID_FUNC_ANZAHL2";
inline constexpr OUStringLiteral HID_FUNC_MAX = u"SC_HID_FUNC_MAX";
inline constexpr OUStringLiteral HID_FUNC_MIN = u"SC_HID_FUNC_MIN";
inline constexpr OUStringLiteral HID_FUNC_VARIANZ = u"SC_HID_FUNC_VARIANZ";
inline constexpr OUStringLiteral HID_FUNC_VARIANZEN = u"SC_HID_FUNC_VARIANZEN";
inline constexpr OUStringLiteral HID_FUNC_STABW = u"SC_HID_FUNC_STABW";
inline constexpr OUStringLiteral HID_FUNC_STABWN = u"SC_HID_FUNC_STABWN";
inline constexpr OUStringLiteral HID_FUNC_MITTELWERT = u"SC_HID_FUNC_MITTELWERT";
inline constexpr OUStringLiteral HID_FUNC_SUMQUADABW = u"SC_HID_FUNC_SUMQUADABW";
inline constexpr OUStringLiteral HID_FUNC_MITTELABW = u"SC_HID_FUNC_MITTELABW";
inline constexpr OUStringLiteral HID_FUNC_SCHIEFE = u"SC_HID_FUNC_SCHIEFE";
inline constexpr OUStringLiteral HID_FUNC_SKEWP = u"SC_HID_FUNC_SKEWP";
inline constexpr OUStringLiteral HID_FUNC_KURT = u"SC_HID_FUNC_KURT";
inline constexpr OUStringLiteral HID_FUNC_GEOMITTEL = u"SC_HID_FUNC_GEOMITTEL";
inline constexpr OUStringLiteral HID_FUNC_HARMITTEL = u"SC_HID_FUNC_HARMITTEL";
inline constexpr OUStringLiteral HID_FUNC_MODALWERT = u"SC_HID_FUNC_MODALWERT";
inline constexpr OUStringLiteral HID_FUNC_MEDIAN = u"SC_HID_FUNC_MEDIAN";
inline constexpr OUStringLiteral HID_FUNC_QUANTIL = u"SC_HID_FUNC_QUANTIL";
inline constexpr OUStringLiteral HID_FUNC_QUARTILE = u"SC_HID_FUNC_QUARTILE";
inline constexpr OUStringLiteral HID_FUNC_KGROESSTE = u"SC_HID_FUNC_KGROESSTE";
inline constexpr OUStringLiteral HID_FUNC_KKLEINSTE = u"SC_HID_FUNC_KKLEINSTE";
inline constexpr OUStringLiteral HID_FUNC_QUANTILSRANG = u"SC_HID_FUNC_QUANTILSRANG";
inline constexpr OUStringLiteral HID_FUNC_RANG = u"SC_HID_FUNC_RANG";
inline constexpr OUStringLiteral HID_FUNC_GESTUTZTMITTEL = u"SC_HID_FUNC_GESTUTZTMITTEL";
inline constexpr OUStringLiteral HID_FUNC_WAHRSCHBEREICH = u"SC_HID_FUNC_WAHRSCHBEREICH";
inline constexpr OUStringLiteral HID_FUNC_B = u"SC_HID_FUNC_B";
inline constexpr OUStringLiteral HID_FUNC_PHI = u"SC_HID_FUNC_PHI";
inline constexpr OUStringLiteral HID_FUNC_GAUSS = u"SC_HID_FUNC_GAUSS";
inline constexpr OUStringLiteral HID_FUNC_FISHER = u"SC_HID_FUNC_FISHER";
inline constexpr OUStringLiteral HID_FUNC_FISHERINV = u"SC_HID_FUNC_FISHERINV";
inline constexpr OUStringLiteral HID_FUNC_BINOMVERT = u"SC_HID_FUNC_BINOMVERT";
inline constexpr OUStringLiteral HID_FUNC_NEGBINOMVERT = u"SC_HID_FUNC_NEGBINOMVERT";
inline constexpr OUStringLiteral HID_FUNC_KRITBINOM = u"SC_HID_FUNC_KRITBINOM";
inline constexpr OUStringLiteral HID_FUNC_POISSON = u"SC_HID_FUNC_POISSON";
inline constexpr OUStringLiteral HID_FUNC_NORMVERT = u"SC_HID_FUNC_NORMVERT";
inline constexpr OUStringLiteral HID_FUNC_NORMINV = u"SC_HID_FUNC_NORMINV";
inline constexpr OUStringLiteral HID_FUNC_STANDNORMVERT = u"SC_HID_FUNC_STANDNORMVERT";
inline constexpr OUStringLiteral HID_FUNC_STANDNORMINV = u"SC_HID_FUNC_STANDNORMINV";
inline constexpr OUStringLiteral HID_FUNC_LOGNORMVERT = u"SC_HID_FUNC_LOGNORMVERT";
inline constexpr OUStringLiteral HID_FUNC_LOGINV = u"SC_HID_FUNC_LOGINV";
inline constexpr OUStringLiteral HID_FUNC_EXPONVERT = u"SC_HID_FUNC_EXPONVERT";
inline constexpr OUStringLiteral HID_FUNC_GAMMAVERT = u"SC_HID_FUNC_GAMMAVERT";
inline constexpr OUStringLiteral HID_FUNC_GAMMAINV = u"SC_HID_FUNC_GAMMAINV";
inline constexpr OUStringLiteral HID_FUNC_GAMMALN = u"SC_HID_FUNC_GAMMALN";
inline constexpr OUStringLiteral HID_FUNC_BETAVERT = u"SC_HID_FUNC_BETAVERT";
inline constexpr OUStringLiteral HID_FUNC_BETAINV = u"SC_HID_FUNC_BETAINV";
inline constexpr OUStringLiteral HID_FUNC_WEIBULL = u"SC_HID_FUNC_WEIBULL";
inline constexpr OUStringLiteral HID_FUNC_HYPGEOMVERT = u"SC_HID_FUNC_HYPGEOMVERT";
inline constexpr OUStringLiteral HID_FUNC_TVERT = u"SC_HID_FUNC_TVERT";
inline constexpr OUStringLiteral HID_FUNC_TINV = u"SC_HID_FUNC_TINV";
inline constexpr OUStringLiteral HID_FUNC_FVERT = u"SC_HID_FUNC_FVERT";
inline constexpr OUStringLiteral HID_FUNC_FINV = u"SC_HID_FUNC_FINV";
inline constexpr OUStringLiteral HID_FUNC_CHIVERT = u"SC_HID_FUNC_CHIVERT";
inline constexpr OUStringLiteral HID_FUNC_CHIINV = u"SC_HID_FUNC_CHIINV";
inline constexpr OUStringLiteral HID_FUNC_STANDARDISIERUNG = u"SC_HID_FUNC_STANDARDISIERUNG";
inline constexpr OUStringLiteral HID_FUNC_VARIATIONEN = u"SC_HID_FUNC_VARIATIONEN";
inline constexpr OUStringLiteral HID_FUNC_VARIATIONEN2 = u"SC_HID_FUNC_VARIATIONEN2";
inline constexpr OUStringLiteral HID_FUNC_KONFIDENZ = u"SC_HID_FUNC_KONFIDENZ";
inline constexpr OUStringLiteral HID_FUNC_GTEST = u"SC_HID_FUNC_GTEST";
inline constexpr OUStringLiteral HID_FUNC_CHITEST = u"SC_HID_FUNC_CHITEST";
inline constexpr OUStringLiteral HID_FUNC_FTEST = u"SC_HID_FUNC_FTEST";
inline constexpr OUStringLiteral HID_FUNC_TTEST = u"SC_HID_FUNC_TTEST";
inline constexpr OUStringLiteral HID_FUNC_BESTIMMTHEITSMASS = u"SC_HID_FUNC_BESTIMMTHEITSMASS";
inline constexpr OUStringLiteral HID_FUNC_ACHSENABSCHNITT = u"SC_HID_FUNC_ACHSENABSCHNITT";
inline constexpr OUStringLiteral HID_FUNC_STEIGUNG = u"SC_HID_FUNC_STEIGUNG";
inline constexpr OUStringLiteral HID_FUNC_STFEHLERYX = u"SC_HID_FUNC_STFEHLERYX";
inline constexpr OUStringLiteral HID_FUNC_PEARSON = u"SC_HID_FUNC_PEARSON";
inline constexpr OUStringLiteral HID_FUNC_KORREL = u"SC_HID_FUNC_KORREL";
inline constexpr OUStringLiteral HID_FUNC_KOVAR = u"SC_HID_FUNC_KOVAR";
inline constexpr OUStringLiteral HID_FUNC_SCHAETZER = u"SC_HID_FUNC_SCHAETZER";
inline constexpr OUStringLiteral HID_FUNC_MINA = u"SC_HID_FUNC_MINA";
inline constexpr OUStringLiteral HID_FUNC_MAXA = u"SC_HID_FUNC_MAXA";
inline constexpr OUStringLiteral HID_FUNC_MITTELWERTA = u"SC_HID_FUNC_MITTELWERTA";
inline constexpr OUStringLiteral HID_FUNC_STABWA = u"SC_HID_FUNC_STABWA";
inline constexpr OUStringLiteral HID_FUNC_STABWNA = u"SC_HID_FUNC_STABWNA";
inline constexpr OUStringLiteral HID_FUNC_VARIANZA = u"SC_HID_FUNC_VARIANZA";
inline constexpr OUStringLiteral HID_FUNC_VARIANZENA = u"SC_HID_FUNC_VARIANZENA";
inline constexpr OUStringLiteral HID_FUNC_CHISQDIST = u"SC_HID_FUNC_CHISQDIST";
inline constexpr OUStringLiteral HID_FUNC_CHISQINV = u"SC_HID_FUNC_CHISQINV";
inline constexpr OUStringLiteral HID_FUNC_GAMMA = u"SC_HID_FUNC_GAMMA";

inline constexpr OUStringLiteral HID_FUNC_ADRESSE = u"SC_HID_FUNC_ADRESSE";
inline constexpr OUStringLiteral HID_FUNC_BEREICHE = u"SC_HID_FUNC_BEREICHE";
inline constexpr OUStringLiteral HID_FUNC_WAHL = u"SC_HID_FUNC_WAHL";
inline constexpr OUStringLiteral HID_FUNC_SPALTE = u"SC_HID_FUNC_SPALTE";
inline constexpr OUStringLiteral HID_FUNC_ZEILE = u"SC_HID_FUNC_ZEILE";
inline constexpr OUStringLiteral HID_FUNC_SPALTEN = u"SC_HID_FUNC_SPALTEN";
inline constexpr OUStringLiteral HID_FUNC_ZEILEN = u"SC_HID_FUNC_ZEILEN";
inline constexpr OUStringLiteral HID_FUNC_WVERWEIS = u"SC_HID_FUNC_WVERWEIS";
inline constexpr OUStringLiteral HID_FUNC_SVERWEIS = u"SC_HID_FUNC_SVERWEIS";
inline constexpr OUStringLiteral HID_FUNC_INDEX = u"SC_HID_FUNC_INDEX";
inline constexpr OUStringLiteral HID_FUNC_INDIREKT = u"SC_HID_FUNC_INDIREKT";
inline constexpr OUStringLiteral HID_FUNC_VERWEIS = u"SC_HID_FUNC_VERWEIS";
inline constexpr OUStringLiteral HID_FUNC_VERGLEICH = u"SC_HID_FUNC_VERGLEICH";
inline constexpr OUStringLiteral HID_FUNC_VERSCHIEBUNG = u"SC_HID_FUNC_VERSCHIEBUNG";
inline constexpr OUStringLiteral HID_FUNC_FEHLERTYP = u"SC_HID_FUNC_FEHLERTYP";
inline constexpr OUStringLiteral HID_FUNC_VORLAGE = u"SC_HID_FUNC_VORLAGE";
inline constexpr OUStringLiteral HID_FUNC_DDE = u"SC_HID_FUNC_DDE";
inline constexpr OUStringLiteral HID_FUNC_TABELLE = u"SC_HID_FUNC_TABELLE";
inline constexpr OUStringLiteral HID_FUNC_TABELLEN = u"SC_HID_FUNC_TABELLEN";
inline constexpr OUStringLiteral HID_FUNC_HYPERLINK = u"SC_HID_FUNC_HYPERLINK";
inline constexpr OUStringLiteral HID_FUNC_GETPIVOTDATA = u"SC_HID_FUNC_GETPIVOTDATA";

inline constexpr OUStringLiteral HID_FUNC_CODE = u"SC_HID_FUNC_CODE";
inline constexpr OUStringLiteral HID_FUNC_DM = u"SC_HID_FUNC_DM";
inline constexpr OUStringLiteral HID_FUNC_ZEICHEN = u"SC_HID_FUNC_ZEICHEN";
inline constexpr OUStringLiteral HID_FUNC_SAEUBERN = u"SC_HID_FUNC_SAEUBERN";
inline constexpr OUStringLiteral HID_FUNC_VERKETTEN = u"SC_HID_FUNC_VERKETTEN";
inline constexpr OUStringLiteral HID_FUNC_IDENTISCH = u"SC_HID_FUNC_IDENTISCH";
inline constexpr OUStringLiteral HID_FUNC_FINDEN = u"SC_HID_FUNC_FINDEN";
inline constexpr OUStringLiteral HID_FUNC_SUCHEN = u"SC_HID_FUNC_SUCHEN";
inline constexpr OUStringLiteral HID_FUNC_GLAETTEN = u"SC_HID_FUNC_GLAETTEN";
inline constexpr OUStringLiteral HID_FUNC_GROSS2 = u"SC_HID_FUNC_GROSS2";
inline constexpr OUStringLiteral HID_FUNC_GROSS = u"SC_HID_FUNC_GROSS";
inline constexpr OUStringLiteral HID_FUNC_KLEIN = u"SC_HID_FUNC_KLEIN";
inline constexpr OUStringLiteral HID_FUNC_WERT = u"SC_HID_FUNC_WERT";
inline constexpr OUStringLiteral HID_FUNC_TEXT = u"SC_HID_FUNC_TEXT";
inline constexpr OUStringLiteral HID_FUNC_T = u"SC_HID_FUNC_T";
inline constexpr OUStringLiteral HID_FUNC_ERSETZEN = u"SC_HID_FUNC_ERSETZEN";
inline constexpr OUStringLiteral HID_FUNC_FEST = u"SC_HID_FUNC_FEST";
inline constexpr OUStringLiteral HID_FUNC_LAENGE = u"SC_HID_FUNC_LAENGE";
inline constexpr OUStringLiteral HID_FUNC_LINKS = u"SC_HID_FUNC_LINKS";
inline constexpr OUStringLiteral HID_FUNC_RECHTS = u"SC_HID_FUNC_RECHTS";
inline constexpr OUStringLiteral HID_FUNC_TEIL = u"SC_HID_FUNC_TEIL";
inline constexpr OUStringLiteral HID_FUNC_LENB = u"SC_HID_FUNC_LENB";
inline constexpr OUStringLiteral HID_FUNC_RIGHTB = u"SC_HID_FUNC_RIGHTB";
inline constexpr OUStringLiteral HID_FUNC_LEFTB = u"SC_HID_FUNC_LEFTB";
inline constexpr OUStringLiteral HID_FUNC_MIDB = u"SC_HID_FUNC_MIDB";
inline constexpr OUStringLiteral HID_FUNC_WIEDERHOLEN = u"SC_HID_FUNC_WIEDERHOLEN";
inline constexpr OUStringLiteral HID_FUNC_WECHSELN = u"SC_HID_FUNC_WECHSELN";
inline constexpr OUStringLiteral HID_FUNC_BASIS = u"SC_HID_FUNC_BASIS";
inline constexpr OUStringLiteral HID_FUNC_DEZIMAL = u"SC_HID_FUNC_DEZIMAL";
inline constexpr OUStringLiteral HID_FUNC_ROEMISCH = u"SC_HID_FUNC_ROEMISCH";
inline constexpr OUStringLiteral HID_FUNC_ARABISCH = u"SC_HID_FUNC_ARABISCH";
inline constexpr OUStringLiteral HID_FUNC_BAHTTEXT = u"SC_HID_FUNC_BAHTTEXT";
inline constexpr OUStringLiteral HID_FUNC_JIS = u"SC_HID_FUNC_JIS";
inline constexpr OUStringLiteral HID_FUNC_ASC = u"SC_HID_FUNC_ASC";
inline constexpr OUStringLiteral HID_FUNC_UNICODE = u"SC_HID_FUNC_UNICODE";
inline constexpr OUStringLiteral HID_FUNC_UNICHAR = u"SC_HID_FUNC_UNICHAR";
inline constexpr OUStringLiteral HID_FUNC_NUMBERVALUE = u"SC_HID_FUNC_NUMBERVALUE";
inline constexpr OUStringLiteral HID_FUNC_BITAND = u"SC_HID_FUNC_BITAND";
inline constexpr OUStringLiteral HID_FUNC_BITOR = u"SC_HID_FUNC_BITOR";
inline constexpr OUStringLiteral HID_FUNC_BITXOR = u"SC_HID_FUNC_BITXOR";
inline constexpr OUStringLiteral HID_FUNC_BITLSHIFT = u"SC_HID_FUNC_BITLSHIFT";
inline constexpr OUStringLiteral HID_FUNC_BITRSHIFT = u"SC_HID_FUNC_BITRSHIFT";
inline constexpr OUStringLiteral HID_FUNC_FILTERXML = u"SC_HID_FUNC_FILTERXML";
inline constexpr OUStringLiteral HID_FUNC_WEBSERVICE = u"SC_HID_FUNC_WEBSERVICE";
inline constexpr OUStringLiteral HID_FUNC_ENCODEURL = u"SC_HID_FUNC_ENCODEURL";
inline constexpr OUStringLiteral HID_FUNC_COLOR = u"SC_HID_FUNC_COLOR";
inline constexpr OUStringLiteral HID_FUNC_COVARIANCE_P = u"SC_HID_FUNC_COVARIANCE_P";
inline constexpr OUStringLiteral HID_FUNC_COVARIANCE_S = u"SC_HID_FUNC_COVARIANCE_S";
inline constexpr OUStringLiteral HID_FUNC_ST_DEV_P_MS = u"SC_HID_FUNC_ST_DEV_P_MS";
inline constexpr OUStringLiteral HID_FUNC_ST_DEV_S = u"SC_HID_FUNC_ST_DEV_S";
inline constexpr OUStringLiteral HID_FUNC_VAR_P_MS = u"SC_HID_FUNC_VAR_P_MS";
inline constexpr OUStringLiteral HID_FUNC_VAR_S = u"SC_HID_FUNC_VAR_S";
inline constexpr OUStringLiteral HID_FUNC_BETADIST_MS = u"SC_HID_FUNC_BETADIST_MS";
inline constexpr OUStringLiteral HID_FUNC_BETAINV_MS = u"SC_HID_FUNC_BETAINV_MS";
inline constexpr OUStringLiteral HID_FUNC_BINOM_DIST_MS = u"SC_HID_FUNC_BINOM_DIST_MS";
inline constexpr OUStringLiteral HID_FUNC_BINOM_INV_MS = u"SC_HID_FUNC_BINOM_INV_MS";
inline constexpr OUStringLiteral HID_FUNC_CHIINV_MS = u"SC_HID_FUNC_CHIINV_MS";
inline constexpr OUStringLiteral HID_FUNC_CHIVERT_MS = u"SC_HID_FUNC_CHIVERT_MS";
inline constexpr OUStringLiteral HID_FUNC_CHITEST_MS = u"SC_HID_FUNC_CHITEST_MS";
inline constexpr OUStringLiteral HID_FUNC_CHISQDIST_MS = u"SC_HID_FUNC_CHISQDIST_MS";
inline constexpr OUStringLiteral HID_FUNC_CHISQINV_MS = u"SC_HID_FUNC_CHISQINV_MS";
inline constexpr OUStringLiteral HID_FUNC_CONFIDENCE_N = u"SC_HID_FUNC_CONFIDENCE_N";
inline constexpr OUStringLiteral HID_FUNC_CONFIDENCE_T = u"SC_HID_FUNC_CONFIDENCE_T";
inline constexpr OUStringLiteral HID_FUNC_F_DIST_LT = u"SC_HID_FUNC_F_DIST_LT";
inline constexpr OUStringLiteral HID_FUNC_F_DIST_RT = u"SC_HID_FUNC_F_DIST_RT";
inline constexpr OUStringLiteral HID_FUNC_F_INV_LT = u"SC_HID_FUNC_F_INV_LT";
inline constexpr OUStringLiteral HID_FUNC_F_INV_RT = u"SC_HID_FUNC_F_INV_RT";
inline constexpr OUStringLiteral HID_FUNC_F_TEST_MS = u"SC_HID_FUNC_F_TEST_MS";
inline constexpr OUStringLiteral HID_FUNC_EXP_DIST_MS = u"SC_HID_FUNC_EXP_DIST_MS";
inline constexpr OUStringLiteral HID_FUNC_HYP_GEOM_DIST_MS = u"SC_HID_FUNC_HYP_GEOM_DIST_MS";
inline constexpr OUStringLiteral HID_FUNC_POISSON_DIST_MS = u"SC_HID_FUNC_POISSON_DIST_MS";
inline constexpr OUStringLiteral HID_FUNC_WEIBULL_DIST_MS = u"SC_HID_FUNC_WEIBULL_DIST_MS";
inline constexpr OUStringLiteral HID_FUNC_GAMMADIST_MS = u"SC_HID_FUNC_GAMMADIST_MS";
inline constexpr OUStringLiteral HID_FUNC_GAMMAINV_MS = u"SC_HID_FUNC_GAMMAINV_MS";
inline constexpr OUStringLiteral HID_FUNC_GAMMALN_MS = u"SC_HID_FUNC_GAMMALN_MS";
inline constexpr OUStringLiteral HID_FUNC_LOGNORMDIST_MS = u"SC_HID_FUNC_LOGNORMDIST_MS";
inline constexpr OUStringLiteral HID_FUNC_NORMDIST_MS = u"SC_HID_FUNC_NORMDIST_MS";
inline constexpr OUStringLiteral HID_FUNC_NORMINV_MS = u"SC_HID_FUNC_NORMINV_MS";
inline constexpr OUStringLiteral HID_FUNC_STD_NORMDIST_MS = u"SC_HID_FUNC_STD_NORMDIST_MS";
inline constexpr OUStringLiteral HID_FUNC_STD_NORMINV_MS = u"SC_HID_FUNC_STD_NORMINV_MS";
inline constexpr OUStringLiteral HID_FUNC_TDIST_2T = u"SC_HID_FUNC_TDIST_2T";
inline constexpr OUStringLiteral HID_FUNC_TDIST_MS = u"SC_HID_FUNC_TDIST_MS";
inline constexpr OUStringLiteral HID_FUNC_TDIST_RT = u"SC_HID_FUNC_TDIST_RT";
inline constexpr OUStringLiteral HID_FUNC_TINV_2T = u"SC_HID_FUNC_TINV_2T";
inline constexpr OUStringLiteral HID_FUNC_TINV_MS = u"SC_HID_FUNC_TINV_MS";
inline constexpr OUStringLiteral HID_FUNC_TTEST_MS = u"SC_HID_FUNC_TTEST_MS";
inline constexpr OUStringLiteral HID_FUNC_PERCENTILE_EXC = u"SC_HID_FUNC_PERCENTILE_EXC";
inline constexpr OUStringLiteral HID_FUNC_PERCENTILE_INC = u"SC_HID_FUNC_PERCENTILE_INC";
inline constexpr OUStringLiteral HID_FUNC_PERCENTRANK_EXC = u"SC_HID_FUNC_PERCENTRANK_EXC";
inline constexpr OUStringLiteral HID_FUNC_PERCENTRANK_INC = u"SC_HID_FUNC_PERCENTRANK_INC";
inline constexpr OUStringLiteral HID_FUNC_QUARTILE_INC = u"SC_HID_FUNC_QUARTILE_INC";
inline constexpr OUStringLiteral HID_FUNC_QUARTILE_EXC = u"SC_HID_FUNC_QUARTILE_EXC";
inline constexpr OUStringLiteral HID_FUNC_RANK_EQ = u"SC_HID_FUNC_RANK_EQ";
inline constexpr OUStringLiteral HID_FUNC_RANK_AVG = u"SC_HID_FUNC_RANK_AVG";
inline constexpr OUStringLiteral HID_FUNC_MODAL_VALUE_MS = u"SC_HID_FUNC_MODAL_VALUE_MS";
inline constexpr OUStringLiteral HID_FUNC_MODAL_VALUE_MULTI = u"SC_HID_FUNC_MODAL_VALUE_MULTI";
inline constexpr OUStringLiteral HID_FUNC_NEGBINOMDIST_MS = u"SC_HID_FUNC_NEGBINOMDIST_MS";
inline constexpr OUStringLiteral HID_FUNC_Z_TEST_MS = u"SC_HID_FUNC_Z_TEST_MS";
inline constexpr OUStringLiteral HID_FUNC_CEIL_MS = u"SC_HID_FUNC_CEIL_MS";
inline constexpr OUStringLiteral HID_FUNC_CEIL_PRECISE = u"SC_HID_FUNC_CEIL_PRECISE";
inline constexpr OUStringLiteral HID_FUNC_CEIL_ISO = u"SC_HID_FUNC_CEIL_ISO";
inline constexpr OUStringLiteral HID_FUNC_FLOOR_MS = u"SC_HID_FUNC_FLOOR_MS";
inline constexpr OUStringLiteral HID_FUNC_NETWORKDAYS = u"SC_HID_FUNC_NETWORKDAYS";
inline constexpr OUStringLiteral HID_FUNC_NETWORKDAYS_MS = u"SC_HID_FUNC_NETWORKDAYS_MS";
inline constexpr OUStringLiteral HID_FUNC_WORKDAY_MS = u"SC_HID_FUNC_WORKDAY_MS";
inline constexpr OUStringLiteral HID_FUNC_ERF_MS = u"SC_HID_FUNC_ERF_MS";
inline constexpr OUStringLiteral HID_FUNC_ERFC_MS = u"SC_HID_FUNC_ERFC_MS";
inline constexpr OUStringLiteral HID_FUNC_AGGREGATE = u"SC_HID_FUNC_AGGREGATE";
inline constexpr OUStringLiteral HID_FUNC_ERROR_TYPE_ODF = u"SC_HID_FUNC_ERROR_TYPE_ODF";
inline constexpr OUStringLiteral HID_FUNC_CEIL_MATH = u"SC_HID_FUNC_CEIL_MATH";
inline constexpr OUStringLiteral HID_FUNC_FLOOR_MATH = u"SC_HID_FUNC_FLOOR_MATH";
inline constexpr OUStringLiteral HID_FUNC_FLOOR_PRECISE = u"SC_HID_FUNC_FLOOR_PRECISE";
inline constexpr OUStringLiteral HID_FUNC_RAWSUBTRACT = u"SC_HID_FUNC_RAWSUBTRACT";
inline constexpr OUStringLiteral HID_FUNC_WEEKNUM_OOO = u"SC_HID_FUNC_WEEKNUM_OOO";
inline constexpr OUStringLiteral HID_FUNC_FORECAST_ETS_ADD = u"SC_HID_FUNC_FORECAST_ETS_ADD";
inline constexpr OUStringLiteral HID_FUNC_FORECAST_ETS_MUL = u"SC_HID_FUNC_FORECAST_ETS_MUL";
inline constexpr OUStringLiteral HID_FUNC_FORECAST_ETS_PIA = u"SC_HID_FUNC_FORECAST_ETS_PIA";
inline constexpr OUStringLiteral HID_FUNC_FORECAST_ETS_PIM = u"SC_HID_FUNC_FORECAST_ETS_PIM";
inline constexpr OUStringLiteral HID_FUNC_FORECAST_ETS_SEA = u"SC_HID_FUNC_FORECAST_ETS_SEA";
inline constexpr OUStringLiteral HID_FUNC_FORECAST_ETS_STA = u"SC_HID_FUNC_FORECAST_ETS_STA";
inline constexpr OUStringLiteral HID_FUNC_FORECAST_ETS_STM = u"SC_HID_FUNC_FORECAST_ETS_STM";
inline constexpr OUStringLiteral HID_FUNC_FORECAST_LIN = u"SC_HID_FUNC_FORECAST_LIN";
inline constexpr OUStringLiteral HID_FUNC_CONCAT_MS = u"SC_HID_FUNC_CONCAT_MS";
inline constexpr OUStringLiteral HID_FUNC_TEXTJOIN_MS = u"SC_HID_FUNC_TEXTJOIN_MS";
inline constexpr OUStringLiteral HID_FUNC_IFS_MS = u"SC_HID_FUNC_IFS_MS";
inline constexpr OUStringLiteral HID_FUNC_SWITCH_MS = u"SC_HID_FUNC_SWITCH_MS";
inline constexpr OUStringLiteral HID_FUNC_MINIFS_MS = u"SC_HID_FUNC_MINIFS_MS";
inline constexpr OUStringLiteral HID_FUNC_MAXIFS_MS = u"SC_HID_FUNC_MAXIFS_MS";
inline constexpr OUStringLiteral HID_FUNC_ROUNDSIG = u"SC_HID_FUNC_ROUNDSIG";
inline constexpr OUStringLiteral HID_FUNC_REPLACEB = u"SC_HID_FUNC_REPLACEB";
inline constexpr OUStringLiteral HID_FUNC_FINDB = u"SC_HID_FUNC_FINDB";
inline constexpr OUStringLiteral HID_FUNC_SEARCHB = u"SC_HID_FUNC_SEARCHB";
inline constexpr OUStringLiteral HID_FUNC_REGEX = u"SC_HID_FUNC_REGEX";
inline constexpr OUStringLiteral HID_FUNC_FOURIER = u"SC_HID_FUNC_FOURIER";
inline constexpr OUStringLiteral HID_FUNC_RAND_NV = u"SC_HID_FUNC_RAND_NV";
inline constexpr OUStringLiteral HID_FUNC_RANDBETWEEN_NV = u"SC_HID_FUNC_RANDBETWEEN_NV";

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
