/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#pragma once

#include <rtl/string.hxx>

inline constexpr OStringLiteral HID_SDDRAWVIEWSHELL = "SD_HID_SDDRAWVIEWSHELL";
inline constexpr OStringLiteral HID_SDGRAPHICVIEWSHELL = "SD_HID_SDGRAPHICVIEWSHELL";
inline constexpr OStringLiteral HID_SDOUTLINEVIEWSHELL = "SD_HID_SDOUTLINEVIEWSHELL";

inline constexpr OStringLiteral HID_SD_WIN_PRESENTATION = "SD_HID_SD_WIN_PRESENTATION";

#define HID_SD_HTMLEXPORT_PAGE1                                 "SD_HID_SD_HTMLEXPORT_PAGE1"
#define HID_SD_HTMLEXPORT_PAGE2                                 "SD_HID_SD_HTMLEXPORT_PAGE2"
#define HID_SD_HTMLEXPORT_PAGE3                                 "SD_HID_SD_HTMLEXPORT_PAGE3"
#define HID_SD_HTMLEXPORT_PAGE4                                 "SD_HID_SD_HTMLEXPORT_PAGE4"
#define HID_SD_HTMLEXPORT_PAGE5                                 "SD_HID_SD_HTMLEXPORT_PAGE5"
#define HID_SD_HTMLEXPORT_PAGE6                                 "SD_HID_SD_HTMLEXPORT_PAGE6"

inline constexpr OStringLiteral HID_SD_TABBAR_PAGES = "SD_HID_SD_TABBAR_PAGES";
inline constexpr OStringLiteral HID_SD_TABBAR_LAYERS = "SD_HID_SD_TABBAR_LAYERS";

inline constexpr OStringLiteral HID_SD_NAMEDIALOG_OBJECT = "SD_HID_SD_NAMEDIALOG_OBJECT";
inline constexpr OStringLiteral HID_SD_NAMEDIALOG_PAGE = "SD_HID_SD_NAMEDIALOG_PAGE";
inline constexpr OStringLiteral HID_SD_NAMEDIALOG_LINEEND = "SD_HID_SD_NAMEDIALOG_LINEEND";

inline constexpr OStringLiteral HID_SD_TASK_PANE_PREVIEW_CURRENT = "SD_HID_SD_TASK_PANE_PREVIEW_CURRENT";
inline constexpr OStringLiteral HID_SD_TASK_PANE_PREVIEW_RECENT = "SD_HID_SD_TASK_PANE_PREVIEW_RECENT";
inline constexpr OStringLiteral HID_SD_TASK_PANE_PREVIEW_ALL = "SD_HID_SD_TASK_PANE_PREVIEW_ALL";
inline constexpr OStringLiteral HID_SD_TASK_PANE_PREVIEW_LAYOUTS = "SD_HID_SD_TASK_PANE_PREVIEW_LAYOUTS";

inline constexpr OStringLiteral HID_SD_CUSTOMANIMATIONPANE_PRESETPROPERTYBOX = "SD_HID_SD_CUSTOMANIMATIONPANE_PRESETPROPERTYBOX";
inline constexpr OStringLiteral HID_SD_CUSTOMANIMATIONPANE_COLORPROPERTYBOX = "SD_HID_SD_CUSTOMANIMATIONPANE_COLORPROPERTYBOX";
inline constexpr OStringLiteral HID_SD_CUSTOMANIMATIONPANE_FONTPROPERTYBOX = "SD_HID_SD_CUSTOMANIMATIONPANE_FONTPROPERTYBOX";
inline constexpr OStringLiteral HID_SD_CUSTOMANIMATIONPANE_CHARHEIGHTPROPERTYBOX = "SD_HID_SD_CUSTOMANIMATIONPANE_CHARHEIGHTPROPERTYBOX";
inline constexpr OStringLiteral HID_SD_CUSTOMANIMATIONPANE_ROTATIONPROPERTYBOX = "SD_HID_SD_CUSTOMANIMATIONPANE_ROTATIONPROPERTYBOX";
inline constexpr OStringLiteral HID_SD_CUSTOMANIMATIONPANE_TRANSPARENCYPROPERTYBOX = "SD_HID_SD_CUSTOMANIMATIONPANE_TRANSPARENCYPROPERTYBOX";
inline constexpr OStringLiteral HID_SD_CUSTOMANIMATIONPANE_SCALEPROPERTYBOX = "SD_HID_SD_CUSTOMANIMATIONPANE_SCALEPROPERTYBOX";
inline constexpr OStringLiteral HID_SD_CUSTOMANIMATIONPANE_FONTSTYLEPROPERTYBOX = "SD_HID_SD_CUSTOMANIMATIONPANE_FONTSTYLEPROPERTYBOX";


inline constexpr OStringLiteral HID_SD_RULER_HORIZONTAL = "SD_HID_SD_RULER_HORIZONTAL";
inline constexpr OStringLiteral HID_SD_RULER_VERTICAL = "SD_HID_SD_RULER_VERTICAL";

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
