# -*- Mode: makefile-gmake; tab-width: 4; indent-tabs-mode: t -*-
#
# This file is part of the LibreOffice project.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#

# AutoInstall class

define gb_AutoInstall__make_define
echo "#define auto_$*_ALL \ " >> $@
$(foreach binary,$(filter-out $(lastword $(1)),$(1)),echo "    $(subst .,_,$(subst -,_,$(binary))), \ " >> $@;)
echo "    $(subst .,_,$(subst -,_,$(lastword $(1))))" >> $@;
echo "" >> $@
endef

define gb_AutoInstall__gen_define
$(file >>$@,#define auto_$*_ALL \)
$(foreach binary,$(filter-out $(lastword $(1)),$(1)),$(file >>$@,\
	$(subst .,_,$(subst -,_,$(binary))), \))
$(file >>$@,\
	$(subst .,_,$(subst -,_,$(lastword $(1)))))

endef

define gb_AutoInstall__gen_lib
$(SCP2LIBTEMPLATE)(auto_$*_lib_$(subst .,_,$(subst -,_,$(1))),$(call gb_Library_get_runtime_filename,$(1))$(if $(SCP2COMPONENTCONDITION),$(COMMA)$(SCP2COMPONENTCONDITION)))

endef

$(dir $(call gb_AutoInstall_get_target,%)).dir :
	$(if $(wildcard $(dir $@)),,mkdir -p $(dir $@))

$(call gb_AutoInstall_get_target,%) : $(GBUILDDIR)/AutoInstall.mk \
		$(SRCDIR)/Repository.mk $(SRCDIR)/RepositoryExternal.mk \
		$(BUILDDIR)/config_host.mk
	$(call gb_Output_announce,$*,$(true),AIN,3)
ifeq ($(HAVE_GNUMAKE_FILE_FUNC),)
	echo "/* autogenerated installs for group $* */" > $@
	$(call gb_AutoInstall__make_define,\
		$(foreach lib,$(gb_Library_MODULE_$*),auto_$*_lib_$(lib)) \
		$(foreach lib,$(gb_SdkLinkLibrary_MODULE_$*),auto_$*_link_$(lib)) \
		$(foreach exe,$(gb_Executable_MODULE_$*),auto_$*_exe_$(exe)) \
		$(foreach jar,$(gb_Jar_MODULE_$*),auto_$*_jar_$(jar)) \
		$(foreach pkg,$(gb_Package_MODULE_$*),auto_$*_pkg_$(pkg)))
	$(foreach lib,$(gb_Library_MODULE_$*),\
		echo '$(SCP2LIBTEMPLATE)(auto_$*_lib_$(subst .,_,$(subst -,_,$(lib))),$(call gb_Library_get_runtime_filename,$(lib))$(if $(SCP2COMPONENTCONDITION),$(COMMA)$(SCP2COMPONENTCONDITION)))' >> $@;)
else
	$(file >$@,/* autogenerated installs for group $* */)
	$(call gb_AutoInstall__gen_define,\
		$(foreach lib,$(gb_Library_MODULE_$*),auto_$*_lib_$(lib)) \
		$(foreach lib,$(gb_SdkLinkLibrary_MODULE_$*),auto_$*_link_$(lib)) \
		$(foreach exe,$(gb_Executable_MODULE_$*),auto_$*_exe_$(exe)) \
		$(foreach jar,$(gb_Jar_MODULE_$*),auto_$*_jar_$(jar)) \
		$(foreach pkg,$(gb_Package_MODULE_$*),auto_$*_pkg_$(pkg)))
	$(file >>$@,$(foreach lib,$(gb_Library_MODULE_$*),$(call gb_AutoInstall__gen_lib,$(lib))))
endif
	$(foreach lib,$(gb_SdkLinkLibrary_MODULE_$*),\
		echo 'SDK_LIBRARY_LINK(auto_$*_link_$(lib),$(notdir $(call gb_Library_get_sdk_link_lib,$(lib))),../../program/$(call gb_Library_get_runtime_filename,$(lib)))' >> $@;)
	$(foreach exe,$(gb_Executable_MODULE_$*),\
		echo "$(SCP2EXETEMPLATE)(auto_$*_exe_$(subst .,_,$(subst -,_,$(exe))),$(call gb_Executable_get_filename,$(exe)))" >> $@;)
	$(foreach jar,$(gb_Jar_MODULE_$*),\
		echo '$(SCP2JARTEMPLATE)(auto_$*_jar_$(subst .,_,$(subst -,_,$(jar))),$(jar).jar)' >> $@;)
	$(foreach pkg,$(gb_Package_MODULE_$*),\
		echo 'PACKAGE_FILELIST(auto_$*_pkg_$(subst -,_,$(pkg)),$(pkg).filelist)' >> $@;)


$(call gb_AutoInstall_get_clean_target,%) :
	$(call gb_Output_announce,$*,$(false),AIL,3)
	rm -f $(call gb_AutoInstall_get_target,$*)

define gb_AutoInstall_AutoInstall
$(call gb_AutoInstall_get_target,all) :| $(dir $(call gb_AutoInstall_get_target,all)).dir

$$(eval $$(call gb_Module_register_target,$(call gb_AutoInstall_get_target,all),$(call gb_AutoInstall_get_clean_target,all)))
$(call gb_Helper_make_userfriendly_targets,all,AutoInstall)

endef

# gb_AutoInstall_add_module module lib_template exe_template jar_template componentcondition
define gb_AutoInstall_add_module
$(call gb_AutoInstall_get_target,all) : $(call gb_AutoInstall_get_target,$(1))
$(call gb_AutoInstall_get_clean_target,all) : $(call gb_AutoInstall_get_clean_target,$(1))
$(call gb_Helper_make_userfriendly_targets,$(1),AutoInstall)

$(call gb_AutoInstall_get_target,$(1)) : $(gb_Module_CURRENTMAKEFILE)
$(call gb_AutoInstall_get_target,$(1)) :| $(dir $(call gb_AutoInstall_get_target,$(1))).dir
$(call gb_AutoInstall_get_target,$(1)) : SCP2LIBTEMPLATE := $(2)
$(call gb_AutoInstall_get_target,$(1)) : SCP2EXETEMPLATE := $(3)
$(call gb_AutoInstall_get_target,$(1)) : SCP2JARTEMPLATE := $(4)
$(call gb_AutoInstall_get_target,$(1)) : SCP2COMPONENTCONDITION := $(5)

endef

# vim: set shiftwidth=4 tabstop=4 noexpandtab:
